package gov.va.vamf.scheduling.restservice.communitycare;

import com.agilex.healthcare.veteranappointment.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.veteranappointment.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.veteranappointment.testutility.TestHelper;
import gov.va.vamf.scheduling.communitycare.domain.CCTypeOfCare;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;

import static org.junit.Assert.assertNotNull;

public class CCTypeOfCaresTest {
    private static MobileHealthClientTestVersion client;

    @BeforeClass
    public static void fixtureSetup() {
        client = TestHelper.createMobileHealthClient();
    }

    @AfterClass
    public static void tearDown(){
        if (client != null) {
            client.getJerseyClient().close();
            client = null;
        }
    }

	private static URI getCCTypeOfCaresUri() {
		String fullUrl = String.format("%s/community-care-services/type-of-cares",
				IntegrationTestConfiguration.getMobileHealthServerBaseUri());

		UriBuilder uriBuilder = UriBuilder.fromUri(fullUrl);

		return uriBuilder.build();
	}

	@Test
	public void getCCTypeOfCares() {
		UriBuilder uriBuilder = UriBuilder.fromUri(getCCTypeOfCaresUri());

		List<CCTypeOfCare> ccTypeOfCares =
				client.getJerseyClient().target(uriBuilder).request(MediaType.APPLICATION_JSON).accept(MediaType.APPLICATION_JSON)
						.get(new GenericType<List<CCTypeOfCare>>() {});

		assertNotNull(ccTypeOfCares);
	}
}
